/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.dom;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMConstants;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMXMLParserWrapper;
import org.apache.axiom.om.impl.OMElementEx;
import org.apache.axiom.om.impl.OMNodeEx;
import org.apache.axiom.om.impl.dom.AttrImpl;
import org.apache.axiom.om.impl.dom.AttributeMap;
import org.apache.axiom.om.impl.dom.DOMConfigurationImpl;
import org.apache.axiom.om.impl.dom.DOMMessageFormatter;
import org.apache.axiom.om.impl.dom.DOMUtil;
import org.apache.axiom.om.impl.dom.DocumentImpl;
import org.apache.axiom.om.impl.dom.NamedNode;
import org.apache.axiom.om.impl.dom.NamedNodeHelper;
import org.apache.axiom.om.impl.dom.NamespaceImpl;
import org.apache.axiom.om.impl.dom.NamespaceIterator;
import org.apache.axiom.om.impl.dom.NodeListImpl;
import org.apache.axiom.om.impl.dom.OMChildElementIterator;
import org.apache.axiom.om.impl.dom.OMElementImplUtil;
import org.apache.axiom.om.impl.dom.ParentNode;
import org.apache.axiom.om.impl.dom.factory.OMDOMFactory;
import org.apache.axiom.om.impl.traverse.OMQNameFilterIterator;
import org.apache.axiom.om.impl.traverse.OMQualifiedNameFilterIterator;
import org.apache.axiom.om.impl.util.EmptyIterator;
import org.apache.axiom.om.impl.util.OMSerializerUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.TypeInfo;

public class ElementImpl
extends ParentNode
implements Element,
OMElementEx,
OMNodeEx,
NamedNode,
OMConstants {
    private static final Log log = LogFactory.getLog(ElementImpl.class);
    private int lineNumber;
    protected OMNamespace namespace;
    protected String localName;
    private AttributeMap attributes;
    private HashMap namespaces;
    private static final EmptyIterator EMPTY_ITERATOR = new EmptyIterator();
    private static final OMNamespace XMLNS_NAMESPACE_WITH_PREFIX = new NamespaceImpl("http://www.w3.org/2000/xmlns/", "xmlns");
    private static final OMNamespace XMLNS_NAMESPACE_WITHOUT_PREFIX = new NamespaceImpl("http://www.w3.org/2000/xmlns/", null);

    public ElementImpl(DocumentImpl ownerDocument, String tagName, OMFactory factory) {
        super(ownerDocument, factory);
        this.localName = tagName;
        this.attributes = new AttributeMap(this);
        this.done = true;
    }

    public ElementImpl(DocumentImpl ownerDocument, String tagName, NamespaceImpl ns, OMFactory factory) {
        super(ownerDocument, factory);
        this.localName = tagName;
        if (ns != null) {
            this.setNamespace(ns);
        }
        this.attributes = new AttributeMap(this);
        this.done = true;
    }

    public ElementImpl(DocumentImpl ownerDocument, String tagName, NamespaceImpl ns, OMXMLParserWrapper builder, OMFactory factory) {
        super(ownerDocument, factory);
        this.localName = tagName;
        if (ns != null) {
            this.setNamespace(ns);
        }
        this.builder = builder;
        this.attributes = new AttributeMap(this);
    }

    public ElementImpl(ParentNode parentNode, String tagName, NamespaceImpl ns, OMFactory factory) {
        this((DocumentImpl)parentNode.getOwnerDocument(), tagName, null, factory);
        parentNode.addChild((OMNode)this);
        this.done = true;
        this.namespace = this.handleNamespace(ns);
    }

    public ElementImpl(ParentNode parentNode, String tagName, NamespaceImpl ns, OMXMLParserWrapper builder, OMFactory factory) {
        this(tagName, ns, builder, factory);
        if (parentNode != null) {
            parentNode.addChild((OMNode)this);
        }
    }

    public ElementImpl(String tagName, NamespaceImpl ns, OMXMLParserWrapper builder, OMFactory factory) {
        this(factory);
        this.localName = tagName;
        if (ns != null) {
            this.setNamespace(ns);
        }
        this.builder = builder;
        this.attributes = new AttributeMap(this);
    }

    public ElementImpl(OMFactory factory) {
        super(factory);
        this.setOwnerDocument(((OMDOMFactory)factory).getDocument());
    }

    private OMNamespace handleNamespace(OMNamespace ns) {
        String prefix;
        String namespaceURI = ns == null ? "" : ns.getNamespaceURI();
        String string = prefix = ns == null ? "" : ns.getPrefix();
        if (namespaceURI.length() == 0 && prefix != null && prefix.length() > 0) {
            throw new IllegalArgumentException("Cannot create a prefixed element with an empty namespace name");
        }
        if (namespaceURI.length() == 0) {
            if (this.getDefaultNamespace() != null) {
                this.declareDefaultNamespace("");
            }
            return null;
        }
        OMNamespace namespace = this.findNamespace(namespaceURI, prefix);
        if (namespace == null) {
            namespace = this.declareNamespace(ns);
        }
        return namespace;
    }

    OMNamespace handleNamespace(String namespaceURI, String prefix) {
        if (prefix.length() == 0 && namespaceURI.length() == 0) {
            OMNamespace namespace = this.getDefaultNamespace();
            if (namespace != null) {
                this.declareDefaultNamespace("");
            }
            return null;
        }
        OMNamespace namespace = this.findNamespace(namespaceURI, prefix);
        if (namespace == null) {
            namespace = this.declareNamespace(namespaceURI, prefix.length() > 0 ? prefix : null);
        }
        return namespace;
    }

    public short getNodeType() {
        return 1;
    }

    public String getNodeName() {
        if (this.namespace != null) {
            if (this.namespace.getPrefix() == null || "".equals(this.namespace.getPrefix())) {
                return this.localName;
            }
            return this.namespace.getPrefix() + ":" + this.localName;
        }
        return this.localName;
    }

    public String getNamespaceURI() {
        if (this.namespace == null) {
            return null;
        }
        String uri = this.namespace.getNamespaceURI();
        return uri.length() == 0 ? null : uri.intern();
    }

    public int getType() throws OMException {
        return 1;
    }

    public void setType(int nodeType) throws OMException {
    }

    public String getTagName() {
        return this.getNodeName();
    }

    public void removeAttribute(String name) throws DOMException {
        String namespacePrefix;
        if (name.startsWith("xmlns") && this.findNamespaceURI(namespacePrefix = DOMUtil.getLocalName(name)) != null) {
            this.removeNamespace(namespacePrefix);
        }
        if (this.attributes != null) {
            this.attributes.removeNamedItem(name);
        }
    }

    public void removeAttributeNS(String namespaceURI, String localName) throws DOMException {
        if ("http://www.w3.org/2000/xmlns/".equals(namespaceURI)) {
            if (this.namespaces != null) {
                this.namespaces.remove(DOMUtil.getLocalName(localName));
            }
        } else if (this.attributes != null) {
            this.attributes.removeNamedItemNS(namespaceURI, localName);
        }
    }

    public Attr removeAttributeNode(Attr oldAttr) throws DOMException {
        if (this.attributes == null || this.attributes.getNamedItem(oldAttr.getName()) == null) {
            String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", 8, null);
            throw new DOMException(8, msg);
        }
        return (AttrImpl)this.attributes.removeNamedItem(oldAttr.getName());
    }

    public boolean hasAttribute(String name) {
        return this.getAttributeNode(name) != null;
    }

    public boolean hasAttributeNS(String namespaceURI, String localName) {
        return this.getAttributeNodeNS(namespaceURI, localName) != null;
    }

    public String getAttribute(String name) {
        if (this.attributes == null) {
            return "";
        }
        Attr attr = (Attr)this.attributes.getNamedItem(name);
        return attr != null ? attr.getValue() : "";
    }

    public Attr getAttributeNode(String name) {
        return this.attributes == null ? null : (AttrImpl)this.attributes.getNamedItem(name);
    }

    public String getAttributeNS(String namespaceURI, String localName) {
        if (this.attributes == null) {
            return "";
        }
        Attr attributeNodeNS = this.getAttributeNodeNS(namespaceURI, localName);
        return attributeNodeNS == null ? "" : attributeNodeNS.getValue();
    }

    public Attr getAttributeNodeNS(String namespaceURI, String localName) {
        if ("http://www.w3.org/2000/xmlns/".equals(namespaceURI)) {
            OMNamespace ns = this.findNamespaceURI(localName);
            String nsuri = ns != null ? ns.getNamespaceURI() : "";
            AttrImpl namespaceAttr = new AttrImpl(this.ownerDocument(), localName, nsuri, this.factory);
            NamespaceImpl xmlNs = new NamespaceImpl("http://www.w3.org/2000/xmlns/", null);
            namespaceAttr.setOMNamespace(xmlNs);
            return namespaceAttr;
        }
        return this.attributes == null ? null : (Attr)this.attributes.getNamedItemNS(namespaceURI, localName);
    }

    public Attr setAttributeNode(Attr attr) throws DOMException {
        AttrImpl attrImpl = (AttrImpl)attr;
        if (attrImpl.getOwnerElement() != null && !this.getOwnerDocument().equals(attr.getOwnerDocument())) {
            String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", 4, null);
            throw new DOMException(4, msg);
        }
        if (attrImpl.isUsed()) {
            String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", 10, null);
            throw new DOMException(10, msg);
        }
        if (attr.getNodeName().startsWith("xmlns:")) {
            this.declareNamespace(attr.getNodeValue(), DOMUtil.getLocalName(attr.getName()));
            return attr;
        }
        if (attr.getNodeName().equals("xmlns")) {
            this.declareDefaultNamespace(attr.getValue());
            return attr;
        }
        if (this.attributes == null) {
            this.attributes = new AttributeMap(this);
        }
        return (Attr)this.attributes.setNamedItem(attr);
    }

    public void setAttribute(String name, String value) throws DOMException {
        if (!DOMUtil.isQualifiedName(name)) {
            String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", 5, null);
            throw new DOMException(5, msg);
        }
        if (name.startsWith("xmlns:")) {
            this.declareNamespace(value, DOMUtil.getLocalName(name));
        } else if (name.equals("xmlns")) {
            this.declareDefaultNamespace(value);
        } else {
            this.setAttributeNode(new AttrImpl(this.ownerDocument(), name, value, this.factory));
        }
    }

    public Attr setAttributeNodeNS(Attr attr) throws DOMException {
        if (attr.getNamespaceURI() != null && attr.getNamespaceURI().equals("http://www.w3.org/2000/xmlns/")) {
            this.declareNamespace(attr.getName(), attr.getValue());
            return attr;
        }
        AttrImpl attrImpl = (AttrImpl)attr;
        if (attrImpl.getOwnerElement() != null && !this.getOwnerDocument().equals(attr.getOwnerDocument())) {
            String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", 4, null);
            throw new DOMException(4, msg);
        }
        if (attrImpl.isUsed()) {
            String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", 10, null);
            throw new DOMException(10, msg);
        }
        if (this.attributes == null) {
            this.attributes = new AttributeMap(this);
        }
        if (attr.getNamespaceURI() != null && this.findNamespace(attr.getNamespaceURI(), attr.getPrefix()) == null) {
            this.declareNamespace(new NamespaceImpl(attr.getNamespaceURI(), attr.getPrefix()));
        }
        return (Attr)this.attributes.setNamedItemNS(attr);
    }

    public void setAttributeNS(String namespaceURI, String qualifiedName, String value) throws DOMException {
        if (namespaceURI != null && !"".equals(namespaceURI)) {
            if (namespaceURI.equals("http://www.w3.org/2000/xmlns/")) {
                this.declareNamespace(value, DOMUtil.getLocalName(qualifiedName));
            } else {
                AttrImpl attr = new AttrImpl(this.ownerDocument(), DOMUtil.getLocalName(qualifiedName), value, this.factory);
                attr.setOMNamespace(new NamespaceImpl(namespaceURI, DOMUtil.getPrefix(qualifiedName)));
                this.setAttributeNodeNS(attr);
            }
        } else {
            this.setAttribute(DOMUtil.getLocalName(qualifiedName), value);
        }
    }

    private OMAttribute addAttribute(String namespaceURI, String qualifiedName, String value) throws DOMException {
        if (!DOMUtil.isQualifiedName(qualifiedName)) {
            String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", 5, null);
            throw new DOMException(5, msg);
        }
        if (this.attributes == null) {
            this.attributes = new AttributeMap(this);
        }
        if (namespaceURI != null) {
            if (!DOMUtil.isValidNamespace(namespaceURI, qualifiedName)) {
                String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", 14, null);
                throw new DOMException(14, msg);
            }
            String localName = DOMUtil.getLocalName(qualifiedName);
            Attr attributeNode = this.getAttributeNodeNS(namespaceURI, localName);
            if (attributeNode != null) {
                AttrImpl tempAttr = (AttrImpl)attributeNode;
                tempAttr.setOMNamespace(new NamespaceImpl(namespaceURI, DOMUtil.getPrefix(qualifiedName)));
                tempAttr.setAttributeValue(value);
                this.attributes.setNamedItem(tempAttr);
                return tempAttr;
            }
            NamespaceImpl ns = new NamespaceImpl(namespaceURI, DOMUtil.getPrefix(qualifiedName));
            AttrImpl attr = new AttrImpl((DocumentImpl)this.getOwnerDocument(), localName, ns, value, this.factory);
            this.attributes.setNamedItem(attr);
            return attr;
        }
        Attr attributeNode = this.getAttributeNode(qualifiedName);
        if (attributeNode != null) {
            AttrImpl tempAttr = (AttrImpl)attributeNode;
            tempAttr.setAttributeValue(value);
            this.attributes.setNamedItem(tempAttr);
            return tempAttr;
        }
        AttrImpl attr = new AttrImpl((DocumentImpl)this.getOwnerDocument(), qualifiedName, value, this.factory);
        this.attributes.setNamedItem(attr);
        return attr;
    }

    public boolean hasAttributes() {
        return this.attributes != null && this.attributes.getLength() > 0 || this.namespaces != null && !this.namespaces.isEmpty();
    }

    public NodeList getElementsByTagNameNS(String namespaceURI, String localName) {
        final QName qname = new QName(namespaceURI, localName);
        return new NodeListImpl(){

            protected Iterator getIterator() {
                return new OMQNameFilterIterator(ElementImpl.this.getDescendants(false), qname);
            }
        };
    }

    public NodeList getElementsByTagName(final String name) {
        if (name.equals("*")) {
            return new NodeListImpl(){

                protected Iterator getIterator() {
                    return ElementImpl.this.getDescendants(false);
                }
            };
        }
        return new NodeListImpl(){

            protected Iterator getIterator() {
                return new OMQualifiedNameFilterIterator(ElementImpl.this.getDescendants(false), name);
            }
        };
    }

    public OMAttribute addAttribute(OMAttribute attr) {
        String prefix;
        OMNamespace ns2;
        String uri;
        OMNamespace namespace;
        OMElement owner = attr.getOwner();
        if (owner != null) {
            if (owner == this) {
                return attr;
            }
            attr = (OMAttribute)((AttrImpl)attr).cloneNode(false);
        }
        if (!((namespace = attr.getNamespace()) == null || (uri = namespace.getNamespaceURI()).length() <= 0 || (ns2 = this.findNamespaceURI(prefix = namespace.getPrefix())) != null && uri.equals(ns2.getNamespaceURI()))) {
            this.declareNamespace(uri, prefix);
        }
        if (attr.getNamespace() != null) {
            this.setAttributeNodeNS((Attr)attr);
        } else {
            this.setAttributeNode((Attr)attr);
        }
        return attr;
    }

    public OMAttribute addAttribute(String localName, String value, OMNamespace ns) {
        String prefix;
        OMNamespace ns2;
        String uri;
        if (!(ns == null || (uri = ns.getNamespaceURI()).length() <= 0 || (ns2 = this.findNamespaceURI(prefix = ns.getPrefix())) != null && uri.equals(ns2.getNamespaceURI()))) {
            this.declareNamespace(uri, prefix);
        }
        return this.addAttribute(new AttrImpl(this.ownerDocument(), localName, ns, value, this.factory));
    }

    public OMNamespace addNamespaceDeclaration(String uri, String prefix) {
        if (this.namespaces == null) {
            this.namespaces = new HashMap(5);
        }
        NamespaceImpl ns = new NamespaceImpl(uri, prefix);
        this.namespaces.put(prefix, ns);
        return ns;
    }

    public OMNamespace declareNamespace(OMNamespace namespace) {
        if (this.namespaces == null) {
            this.namespaces = new HashMap(5);
        }
        if (namespace != null) {
            String prefix = namespace.getPrefix();
            if (prefix == null) {
                prefix = OMSerializerUtil.getNextNSPrefix();
                namespace = new NamespaceImpl(namespace.getNamespaceURI(), prefix);
            }
            if (prefix.length() > 0 && namespace.getNamespaceURI().length() == 0) {
                throw new IllegalArgumentException("Cannot bind a prefix to the empty namespace name");
            }
            if (!namespace.getPrefix().startsWith("xmlns")) {
                this.namespaces.put(namespace.getPrefix(), namespace);
            }
        }
        return namespace;
    }

    public void undeclarePrefix(String prefix) {
        if (this.namespaces == null) {
            this.namespaces = new HashMap(5);
        }
        this.namespaces.put(prefix, new NamespaceImpl("", prefix));
    }

    public OMNamespace declareNamespace(String uri, String prefix) {
        if ("".equals(prefix)) {
            log.warn((Object)"Deprecated usage of OMElement#declareNamespace(String,String) with empty prefix");
            prefix = OMSerializerUtil.getNextNSPrefix();
        }
        NamespaceImpl ns = new NamespaceImpl(uri, prefix);
        return this.declareNamespace(ns);
    }

    public OMNamespace declareDefaultNamespace(String uri) {
        if (this.namespace == null && uri.length() > 0 || this.namespace != null && this.namespace.getPrefix().length() == 0 && !this.namespace.getNamespaceURI().equals(uri)) {
            throw new OMException("Attempt to add a namespace declaration that conflicts with the namespace information of the element");
        }
        NamespaceImpl ns = new NamespaceImpl(uri, "");
        if (this.namespaces == null) {
            this.namespaces = new HashMap(5);
        }
        this.namespaces.put("", ns);
        return ns;
    }

    public OMNamespace getDefaultNamespace() {
        NamespaceImpl defaultNS;
        if (this.namespaces != null && (defaultNS = (NamespaceImpl)this.namespaces.get("")) != null) {
            return defaultNS.getNamespaceURI().length() == 0 ? null : defaultNS;
        }
        ParentNode parentNode = this.parentNode();
        if (parentNode instanceof ElementImpl) {
            ElementImpl element = (ElementImpl)parentNode;
            return element.getDefaultNamespace();
        }
        return null;
    }

    public OMNamespace findNamespace(String uri, String prefix) {
        OMNamespace namespace = this.findDeclaredNamespace(uri, prefix);
        if (namespace != null) {
            return namespace;
        }
        ParentNode parentNode = this.parentNode();
        if (parentNode != null && parentNode instanceof OMElement) {
            namespace = ((ElementImpl)parentNode).findNamespace(uri, prefix);
            if (prefix == null && namespace != null && this.findDeclaredNamespace(null, namespace.getPrefix()) != null) {
                namespace = null;
            }
        }
        if (namespace == null && uri != null && prefix != null && prefix.equals("xml") && uri.equals("http://www.w3.org/XML/1998/namespace")) {
            this.declareNamespace("http://www.w3.org/XML/1998/namespace", "xml");
            namespace = this.findNamespace(uri, prefix);
        }
        return namespace;
    }

    public OMNamespace findNamespaceURI(String prefix) {
        OMNamespace ns;
        OMNamespace oMNamespace = ns = this.namespaces == null ? null : (OMNamespace)this.namespaces.get(prefix);
        if (ns == null) {
            ParentNode parentNode = this.parentNode();
            if (parentNode instanceof OMElement) {
                return ((OMElement)parentNode).findNamespaceURI(prefix);
            }
            return null;
        }
        if (prefix != null && prefix.length() > 0 && ns.getNamespaceURI().length() == 0) {
            return null;
        }
        return ns;
    }

    private OMNamespace findDeclaredNamespace(String uri, String prefix) {
        if (uri == null) {
            return this.namespaces == null ? null : (OMNamespace)this.namespaces.get(prefix);
        }
        if (prefix != null && prefix.equals("xml") && uri.equals("http://www.w3.org/XML/1998/namespace")) {
            return new NamespaceImpl(uri, prefix);
        }
        if (this.namespaces == null) {
            return null;
        }
        if (prefix == null || "".equals(prefix)) {
            for (OMNamespace omNamespace : this.namespaces.values()) {
                String nsURI = omNamespace.getNamespaceURI();
                if (nsURI == null || !nsURI.equals(uri)) continue;
                return omNamespace;
            }
        } else {
            OMNamespace namespace = (OMNamespace)this.namespaces.get(prefix);
            if (namespace != null && uri.equals(namespace.getNamespaceURI())) {
                return namespace;
            }
        }
        return null;
    }

    public OMAttribute getAttribute(QName qname) {
        if (this.attributes == null) {
            return null;
        }
        if (qname.getNamespaceURI().equals("")) {
            return (AttrImpl)this.getAttributeNode(qname.getLocalPart());
        }
        return (AttrImpl)this.getAttributeNodeNS(qname.getNamespaceURI(), qname.getLocalPart());
    }

    public String getAttributeValue(QName qname) {
        OMAttribute attr = this.getAttribute(qname);
        return attr == null ? null : attr.getAttributeValue();
    }

    public OMElement getFirstElement() {
        for (OMNode node = this.getFirstOMChild(); node != null; node = node.getNextOMSibling()) {
            if (node.getType() != 1) continue;
            return (OMElement)node;
        }
        return null;
    }

    public OMNamespace getNamespace() {
        return this.namespace;
    }

    public QName getQName() {
        QName qName = this.namespace != null ? new QName(this.namespace.getNamespaceURI(), this.localName, this.namespace.getPrefix()) : new QName(this.localName);
        return qName;
    }

    public String getText() {
        return OMElementImplUtil.getText((OMElement)this);
    }

    public Reader getTextAsStream(boolean cache) {
        return OMElementImplUtil.getTextAsStream((OMElement)this, cache);
    }

    public QName getTextAsQName() {
        String childText = this.getText().trim();
        return childText.length() == 0 ? null : this.resolveQName(childText);
    }

    public void writeTextTo(Writer out, boolean cache) throws IOException {
        OMElementImplUtil.writeTextTo((OMElement)this, out, cache);
    }

    public void removeAttribute(OMAttribute attr) {
        this.removeAttributeNode((AttrImpl)attr);
    }

    public void setBuilder(OMXMLParserWrapper wrapper) {
        this.builder = wrapper;
    }

    public void setLocalName(String localName) {
        this.localName = localName;
    }

    public void internalSetNamespace(OMNamespace namespace) {
        this.namespace = namespace;
    }

    public void setNamespace(OMNamespace namespace) {
        this.internalSetNamespace(this.handleNamespace(namespace));
    }

    public void setNamespaceWithNoFindInCurrentScope(OMNamespace namespace) {
        this.internalSetNamespace(namespace);
    }

    public void setText(String text) {
        OMNode child;
        while ((child = this.getFirstOMChild()) != null) {
            child.detach();
        }
        if (text != null && text.length() > 0) {
            this.getOMFactory().createOMText((OMContainer)this, text);
        }
    }

    public void setText(QName qname) {
        OMNode child;
        while ((child = this.getFirstOMChild()) != null) {
            child.detach();
        }
        if (qname != null) {
            this.getOMFactory().createOMText((OMContainer)this, qname);
        }
    }

    public void internalSerialize(XMLStreamWriter writer, boolean cache) throws XMLStreamException {
        if (cache || this.done || this.builder == null) {
            OMSerializerUtil.serializeStartpart((OMElement)this, (XMLStreamWriter)writer);
            OMSerializerUtil.serializeChildren((OMContainer)this, (XMLStreamWriter)writer, (boolean)cache);
            OMSerializerUtil.serializeEndpart((XMLStreamWriter)writer);
        } else {
            OMSerializerUtil.serializeByPullStream((OMElement)this, (XMLStreamWriter)writer, (boolean)cache);
        }
    }

    public String toStringWithConsume() throws XMLStreamException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.serializeAndConsume(baos);
        return new String(baos.toByteArray());
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            this.serialize(baos);
        }
        catch (XMLStreamException e) {
            throw new RuntimeException("Can not serialize OM Element " + this.getLocalName(), e);
        }
        return new String(baos.toByteArray());
    }

    public Iterator getChildElements() {
        return new OMChildElementIterator(this.getFirstElement());
    }

    public Iterator getAllDeclaredNamespaces() throws OMException {
        if (this.namespaces == null) {
            return EMPTY_ITERATOR;
        }
        return this.namespaces.values().iterator();
    }

    public Iterator getNamespacesInScope() {
        return new NamespaceIterator((OMElement)this);
    }

    public NamespaceContext getNamespaceContext(boolean detached) {
        return OMElementImplUtil.getNamespaceContext((OMElement)this, detached);
    }

    public Iterator getAllAttributes() {
        if (this.attributes == null) {
            return EMPTY_ITERATOR;
        }
        ArrayList<OMAttribute> list = new ArrayList<OMAttribute>();
        for (int i = 0; i < this.attributes.getLength(); ++i) {
            OMAttribute item = (OMAttribute)this.attributes.getItem(i);
            if (item.getNamespace() != null && item.getNamespace() != null && "http://www.w3.org/2000/xmlns/".equals(item.getNamespace().getNamespaceURI())) continue;
            list.add(item);
        }
        return list.iterator();
    }

    public String getLocalName() {
        return this.localName;
    }

    public String getPrefix() {
        OMNamespace ns = this.getNamespace();
        if (ns == null) {
            return null;
        }
        String prefix = ns.getPrefix();
        return prefix.length() == 0 ? null : prefix;
    }

    public void setPrefix(String prefix) throws DOMException {
        NamedNodeHelper.setPrefix(this, prefix);
    }

    public QName resolveQName(String qname) {
        int idx = qname.indexOf(58);
        if (idx == -1) {
            OMNamespace ns = this.getDefaultNamespace();
            return ns == null ? new QName(qname) : new QName(ns.getNamespaceURI(), qname, "");
        }
        String prefix = qname.substring(0, idx);
        OMNamespace ns = this.findNamespace(null, prefix);
        return ns == null ? null : new QName(ns.getNamespaceURI(), qname.substring(idx + 1), prefix);
    }

    public OMElement cloneOMElement() {
        return (ElementImpl)this.cloneNode(true);
    }

    public void setLineNumber(int lineNumber) {
        this.lineNumber = lineNumber;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public Node cloneNode(boolean deep) {
        ElementImpl newnode = (ElementImpl)super.cloneNode(deep);
        if (this.attributes != null) {
            newnode.attributes = (AttributeMap)this.attributes.cloneMap(newnode);
        }
        return newnode;
    }

    public NamedNodeMap getAttributes() {
        AttributeMap attributeMap = new AttributeMap(this);
        for (int i = 0; i < this.attributes.getLength(); ++i) {
            attributeMap.addItem((Attr)this.attributes.getItem(i));
        }
        if (this.namespaces != null) {
            for (String prefix : this.namespaces.keySet()) {
                AttrImpl attr;
                if (prefix == null) continue;
                OMNamespace ns = (OMNamespace)this.namespaces.get(prefix);
                if ("".equals(prefix)) {
                    attr = new AttrImpl(this.ownerDocument(), "xmlns", ns.getNamespaceURI(), this.factory);
                    attr.setOMNamespace(XMLNS_NAMESPACE_WITHOUT_PREFIX);
                    attributeMap.addItem(attr);
                    continue;
                }
                attr = new AttrImpl(this.ownerDocument(), prefix, ns.getNamespaceURI(), this.factory);
                attr.setOMNamespace(XMLNS_NAMESPACE_WITH_PREFIX);
                attributeMap.addItem(attr);
            }
        }
        return attributeMap;
    }

    public String getNamespaceURI(String prefix) {
        OMNamespace ns = this.findNamespaceURI(prefix);
        return ns != null ? ns.getNamespaceURI() : null;
    }

    public boolean removeNamespace(String prefix) {
        Object ns = this.namespaces.get(prefix);
        if (ns != null) {
            this.namespaces.remove(prefix);
            return true;
        }
        return false;
    }

    public OMNode getNextOMSibling() throws OMException {
        while (!this.done) {
            int token = this.builder.next();
            if (token != 8) continue;
            throw new OMException();
        }
        return super.getNextOMSibling();
    }

    public void discard() throws OMException {
        if (this.done) {
            this.detach();
        } else {
            this.builder.discard((OMElement)this);
        }
    }

    public void setIdAttribute(String name, boolean isId) throws DOMException {
        AttrImpl tempAttr = (AttrImpl)this.getAttributeNode(name);
        if (tempAttr == null) {
            String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", 8, null);
            throw new DOMException(8, msg);
        }
        this.updateIsId(isId, tempAttr);
    }

    public void setIdAttributeNS(String namespaceURI, String localName, boolean isId) throws DOMException {
        AttrImpl tempAttr = (AttrImpl)this.getAttributeNodeNS(namespaceURI, localName);
        if (tempAttr == null) {
            String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", 8, null);
            throw new DOMException(8, msg);
        }
        this.updateIsId(isId, tempAttr);
    }

    public void setIdAttributeNode(Attr idAttr, boolean isId) throws DOMException {
        Iterator attrIter = this.getAllAttributes();
        AttrImpl tempAttr = null;
        while (attrIter.hasNext()) {
            AttrImpl attr = (AttrImpl)attrIter.next();
            if (!attr.equals(idAttr)) continue;
            tempAttr = attr;
            break;
        }
        if (tempAttr == null) {
            String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", 8, null);
            throw new DOMException(8, msg);
        }
        this.updateIsId(isId, tempAttr);
    }

    private void updateIsId(boolean isId, AttrImpl tempAttr) {
        tempAttr.isId = isId;
        if (isId) {
            this.ownerDocument().addIdAttr(tempAttr);
        } else {
            this.ownerDocument().removeIdAttr(tempAttr);
        }
    }

    public TypeInfo getSchemaTypeInfo() {
        throw new UnsupportedOperationException("TODO");
    }

    public void buildWithAttachments() {
        if (!this.done) {
            this.build();
        }
        Iterator iterator = this.getChildren();
        while (iterator.hasNext()) {
            OMNode node = (OMNode)iterator.next();
            node.buildWithAttachments();
        }
    }

    void normalize(DOMConfigurationImpl config) {
        if (config.isEnabled(128)) {
            OMNamespace namespace = this.getNamespace();
            if (namespace == null) {
                if (this.getDefaultNamespace() != null) {
                    this.declareDefaultNamespace("");
                }
            } else {
                OMNamespace namespaceForPrefix = this.findNamespaceURI(namespace.getPrefix());
                if (namespaceForPrefix == null || !namespaceForPrefix.getNamespaceURI().equals(namespace.getNamespaceURI())) {
                    this.declareNamespace(namespace);
                }
            }
        }
        super.normalize(config);
    }
}

