/*
 * Decompiled with CFR 0.152.
 */
package org.theshoemakers.which4j;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.StringTokenizer;

public class Which4J {
    private static boolean debug = false;
    static /* synthetic */ Class class$org$theshoemakers$which4j$Which4J;

    public static void main(String[] args) {
        String s = System.getProperty("line.separator");
        if (args.length == 2) {
            if (args[0].equals("-debug")) {
                debug = true;
                Which4J.findIt(args[1]);
            } else {
                System.err.println("error: unrecognized \"" + args[0] + "\" option ");
                System.exit(-1);
            }
        } else if (args.length == 1 && args[0].equals("-help")) {
            Which4J.usage();
        } else if (args.length == 1) {
            Which4J.findIt(args[0]);
        } else {
            Which4J.usage();
        }
        System.exit(0);
    }

    private static void usage() {
        System.err.println("usage: java Which4J [-debug] <classname>\n\tThe commandline version of Which4J will search the system\n\tclasspath defined in your environment for all occurences\n\tof the class.  Alternatively, you can use this class\n\tprogrammatically to search the current (or any) ClassLoader.\n\tSee the javadoc for more detail.\n\t\n\tNote: if the name of the jar file listed after \"found in:\"\n\tdoesn't match the name of the jar listed next to \"url:\", then \n\tthere is likely a \"Class-Path\" entry in the jar manifest \n\tthat is causing the classloader to indirectly find the class.");
        System.exit(-1);
    }

    private static void findIt(String classname) {
        try {
            URL it;
            String classpath = System.getProperty("java.class.path", "");
            if (classpath.equals("")) {
                System.err.println("error: classpath is not set");
            }
            if (debug) {
                System.out.println("classname: " + classname);
                System.out.println("system classpath = " + classpath);
            }
            if (Which4J.isPrimitiveOrVoid(classname)) {
                System.out.println("'" + classname + "' primitive");
                return;
            }
            StringTokenizer st = new StringTokenizer(classpath, File.pathSeparator);
            String classnameAsResource = classname.replace('.', '/') + ".class";
            boolean checkSystemClassLoader = true;
            while (st.hasMoreTokens()) {
                URL[] url;
                URLClassLoader cl;
                URL it2;
                String token = st.nextToken();
                File classpathElement = new File(token);
                if (debug) {
                    System.out.println(classpathElement.isDirectory() ? "dir: " + token : "jar: " + token);
                }
                if ((it2 = (cl = URLClassLoader.newInstance(url = new URL[]{classpathElement.toURL()}, null)).findResource(classnameAsResource)) == null) continue;
                checkSystemClassLoader = false;
                System.out.println("found in: " + token);
                System.out.println("     url: " + it2.toString());
                System.out.println("");
            }
            if (checkSystemClassLoader && (it = ClassLoader.getSystemResource(classnameAsResource)) != null) {
                checkSystemClassLoader = false;
                System.out.println("found in url: " + it.toString());
                System.out.println("");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String which(String classname) {
        return Which4J.which(classname, (class$org$theshoemakers$which4j$Which4J == null ? (class$org$theshoemakers$which4j$Which4J = Which4J.class$("org.theshoemakers.which4j.Which4J")) : class$org$theshoemakers$which4j$Which4J).getClassLoader());
    }

    public static String which(String classname, ClassLoader loader) {
        URL it;
        if (Which4J.isArrayType(classname)) {
            classname = Which4J.getElementType(classname);
        }
        if (Which4J.isPrimitiveOrVoid(classname)) {
            return "'" + classname + "' primitive";
        }
        String classnameAsResource = classname.replace('.', '/') + ".class";
        if (loader == null) {
            loader = ClassLoader.getSystemClassLoader();
        }
        if ((it = loader.getResource(classnameAsResource)) != null) {
            return it.toString();
        }
        return null;
    }

    public static String which(Class clazz) {
        return Which4J.which(clazz, clazz.getClassLoader());
    }

    public static String which(Class clazz, ClassLoader loader) {
        return Which4J.which(clazz.getName(), loader);
    }

    private static boolean isPrimitiveOrVoid(String classname) {
        return classname.equals("boolean") || classname.equals("byte") || classname.equals("char") || classname.equals("double") || classname.equals("float") || classname.equals("int") || classname.equals("long") || classname.equals("short") || classname.equals("void");
    }

    private static boolean isArrayType(String classname) {
        return classname.startsWith("[");
    }

    private static String getElementType(String classname) {
        String elementType = classname.split("^\\[+")[1];
        char encoding = elementType.charAt(0);
        if (encoding == 'L') {
            return elementType.substring(1, elementType.length() - 1);
        }
        if (encoding == 'Z') {
            return "boolean";
        }
        if (encoding == 'B') {
            return "byte";
        }
        if (encoding == 'C') {
            return "char";
        }
        if (encoding == 'D') {
            return "double";
        }
        if (encoding == 'F') {
            return "float";
        }
        if (encoding == 'I') {
            return "int";
        }
        if (encoding == 'J') {
            return "long";
        }
        if (encoding == 'S') {
            return "short";
        }
        throw new InternalError("unknown array type: '" + encoding + "'.\nplease file a bug report at http://which4j.dev.java.net");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

