/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.util;

import java.security.Principal;
import java.security.cert.X509Certificate;
import org.apache.log4j.Logger;
import org.bouncycastle.asn1.x509.X509Name;
import org.glite.security.util.DN;
import org.glite.security.util.DNImpl;

public class DNHandler {
    static final Logger LOGGER;

    public static DN getIssuer(X509Certificate cert) {
        return DNHandler.getDN(cert.getIssuerDN());
    }

    public static DN getSubject(X509Certificate cert) {
        return DNHandler.getDN(cert.getSubjectDN());
    }

    public static DN getDN(Principal principal) {
        return new DNImpl(principal);
    }

    public static DN getDN(String inputDN) {
        return new DNImpl(inputDN);
    }

    static {
        X509Name.DefaultLookUp.put("email", X509Name.E);
        X509Name.DefaultLookUp.put("serialnumber", X509Name.SN);
        X509Name.DefaultSymbols.put(X509Name.EmailAddress, "Email");
        X509Name.DefaultReverse = false;
        LOGGER = Logger.getLogger(DNHandler.class);
    }
}

