/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.glite.security.util.NamespaceRule;

public class Namespace {
    private static final Logger LOGGER = Logger.getLogger(Namespace.class);
    private Vector m_rules = new Vector();

    public Namespace(BufferedReader in) throws IOException {
        String line = this.readRuleLine(in);
        while (line != null) {
            this.m_rules.add(new NamespaceRule(line));
            line = this.readRuleLine(in);
        }
    }

    public NamespaceRule[] getRules() {
        return this.m_rules.toArray(new NamespaceRule[0]);
    }

    String readRuleLine(BufferedReader in) throws IOException {
        String line = this.readNonCommentLine(in);
        if (line == null) {
            return null;
        }
        while (line.endsWith("\\")) {
            String line2 = this.readNonCommentLine(in);
            if (line2 == null) {
                LOGGER.error((Object)("Error while reading CA Namespace: line \"" + line + "\"is not followed by a continuation of the rule as indicated by the \"\\\" char"));
                throw new IOException("Error while reading CA Namespace: line \"" + line + "\"is not followed by a continuation of the rule as indicated by the \"\\\" char");
            }
            line = line.substring(0, line.length() - 1) + " " + line2;
        }
        return line;
    }

    String readNonCommentLine(BufferedReader in) throws IOException {
        String line = in.readLine();
        while (line != null && ((line = line.trim()).length() == 0 || line.startsWith("#"))) {
            line = in.readLine();
        }
        return line;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < this.m_rules.size(); ++i) {
            buf.append(this.m_rules.get(i) + "\n");
        }
        return buf.toString();
    }
}

