/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms;

import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.x509.GeneralName;
import org.glite.security.voms.FQAN;
import org.glite.security.voms.ac.AttributeCertificate;
import org.glite.security.voms.ac.IetfAttrSyntax;

public class VOMSAttribute {
    private static Logger logger = Logger.getLogger(VOMSAttribute.class);
    public static final String VOMS_ATTR_OID = "1.3.6.1.4.1.8005.100.100.4";
    private AttributeCertificate myAC;
    private String myHostPort;
    private String myVo;
    private Vector myStringList = new Vector();
    private Vector myFQANs = new Vector();

    public VOMSAttribute(AttributeCertificate ac) {
        if (ac == null) {
            throw new IllegalArgumentException("VOMSAttribute: AttributeCertificate is NULL");
        }
        this.myAC = ac;
        List l = ac.getAttributes(VOMS_ATTR_OID);
        if (l == null || l.size() == 0) {
            return;
        }
        try {
            for (ASN1Sequence seq : l) {
                IetfAttrSyntax attr = new IetfAttrSyntax(seq);
                String url = ((DERIA5String)GeneralName.getInstance((Object)((ASN1Sequence)attr.getPolicyAuthority().getDERObject()).getObjectAt(0)).getName()).getString();
                int idx = url.indexOf("://");
                if (idx < 0 || idx == url.length() - 1) {
                    throw new IllegalArgumentException("Bad encoding of VOMS policyAuthority : [" + url + "]");
                }
                this.myVo = url.substring(0, idx);
                this.myHostPort = url.substring(idx + 3);
                if (attr.getValueType() != 1) {
                    throw new IllegalArgumentException("VOMS attribute values are not encoded as octet strings, policyAuthority = " + url);
                }
                Iterator j = attr.getValues().iterator();
                while (j.hasNext()) {
                    String fqan = new String(((ASN1OctetString)j.next()).getOctets());
                    FQAN f = new FQAN(fqan);
                    if (this.myStringList.contains(fqan) || !fqan.startsWith("/" + this.myVo + "/") && !fqan.equals("/" + this.myVo)) continue;
                    this.myStringList.add(fqan);
                    this.myFQANs.add(f);
                }
            }
        }
        catch (IllegalArgumentException ie) {
            throw ie;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Badly encoded VOMS extension in AC issued by " + ac.getIssuer().getName());
        }
    }

    public AttributeCertificate getAC() {
        return this.myAC;
    }

    public List getFullyQualifiedAttributes() {
        return this.myStringList;
    }

    public List getListOfFQAN() {
        return this.myFQANs;
    }

    public String getHostPort() {
        return this.myHostPort;
    }

    public String getVO() {
        return this.myVo;
    }

    public String toString() {
        return "VO      :" + this.myVo + "\n" + "HostPort:" + this.myHostPort + "\n" + "FQANs   :" + this.myFQANs;
    }
}

