/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.ac;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.PublicKey;
import java.security.Signature;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.SimpleTimeZone;
import java.util.Vector;
import javax.security.auth.x500.X500Principal;
import org.apache.log4j.Logger;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERConstructedSet;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DEREncodableVector;
import org.bouncycastle.asn1.DERGeneralizedTime;
import org.bouncycastle.asn1.DERInputStream;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.AttCertValidityPeriod;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.glite.security.voms.ac.AttributeCertificateInfo;
import org.glite.security.voms.ac.Holder;
import org.glite.security.voms.ac.Util;

public class AttributeCertificate
implements DEREncodable {
    protected static Logger logger = Logger.getLogger(AttributeCertificate.class);
    AttributeCertificateInfo acInfo;
    AlgorithmIdentifier signatureAlgorithm;
    DERBitString signatureValue;

    public AttributeCertificate(ASN1Sequence seq) throws IOException {
        this.acInfo = new AttributeCertificateInfo((ASN1Sequence)seq.getObjectAt(0));
        this.signatureAlgorithm = AlgorithmIdentifier.getInstance((Object)seq.getObjectAt(1));
        this.signatureValue = (DERBitString)seq.getObjectAt(2);
    }

    public static AttributeCertificate getInstance(InputStream in) throws IOException {
        DERInputStream dIn = new DERInputStream(in);
        ASN1Sequence seq = (ASN1Sequence)dIn.readObject();
        return new AttributeCertificate(seq);
    }

    public AttributeCertificateInfo getAcinfo() {
        return this.acInfo;
    }

    public ASN1Sequence getAttributes() {
        if (this.acInfo == null) {
            return null;
        }
        return this.acInfo.getAttributes();
    }

    public List getAttributes(String oid) {
        if (oid == null) {
            return Collections.EMPTY_LIST;
        }
        ASN1Sequence seq = this.getAttributes();
        if (seq == null || seq.size() == 0) {
            return Collections.EMPTY_LIST;
        }
        Vector v = new Vector();
        Enumeration e = seq.getObjects();
        while (e.hasMoreElements()) {
            ASN1Sequence attribute = (ASN1Sequence)e.nextElement();
            if (!oid.equals(((DERObjectIdentifier)attribute.getObjectAt(0)).getId())) continue;
            DERConstructedSet set = (DERConstructedSet)attribute.getObjectAt(1);
            Enumeration s = set.getObjects();
            while (s.hasMoreElements()) {
                v.add(s.nextElement());
            }
        }
        return v;
    }

    public X509Extensions getExtensions() {
        return this.acInfo == null ? null : this.acInfo.getExtensions();
    }

    public X500Principal getIssuer() {
        if (this.acInfo == null) {
            return null;
        }
        if (this.acInfo.getIssuer() == null) {
            return null;
        }
        ASN1Sequence seq = (ASN1Sequence)this.acInfo.getIssuer().getIssuerName().getDERObject();
        Enumeration e = seq.getObjects();
        while (e.hasMoreElements()) {
            GeneralName gn = GeneralName.getInstance((Object)((ASN1TaggedObject)e.nextElement()));
            if (gn.getTagNo() != 4) continue;
            return Util.generalNameToX500Name(gn);
        }
        return null;
    }

    public Holder getHolder() {
        return this.acInfo == null ? null : this.acInfo.getHolder();
    }

    private static Date getDate(DERGeneralizedTime time) throws ParseException {
        SimpleDateFormat dateF;
        String t = time.getTime();
        if (t.indexOf("GMT") > 0) {
            dateF = new SimpleDateFormat("yyyyMMddHHmmssz");
        } else {
            dateF = new SimpleDateFormat("yyyyMMddHHmmss'Z'");
            dateF.setTimeZone(new SimpleTimeZone(0, "Z"));
        }
        return dateF.parse(time.getTime());
    }

    public Date getNotAfter() throws ParseException {
        return AttributeCertificate.getDate(this.acInfo.getAttrCertValidityPeriod().getNotAfterTime());
    }

    public Date getNotBefore() throws ParseException {
        return AttributeCertificate.getDate(this.acInfo.getAttrCertValidityPeriod().getNotBeforeTime());
    }

    public AlgorithmIdentifier getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    public DERBitString getSignatureValue() {
        return this.signatureValue;
    }

    public boolean validAt(Date date) {
        AttCertValidityPeriod validity = this.acInfo.getAttrCertValidityPeriod();
        if (date == null) {
            date = new Date();
        }
        try {
            return AttributeCertificate.getDate(validity.getNotAfterTime()).after(date) && AttributeCertificate.getDate(validity.getNotBeforeTime()).before(date);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Invalid validity encoding in Attribute Certificate");
        }
    }

    public boolean isValid() {
        return this.validAt(new Date());
    }

    public boolean verify(PublicKey key) {
        Object error = null;
        try {
            ByteArrayOutputStream b = new ByteArrayOutputStream();
            new DEROutputStream((OutputStream)b).writeObject((Object)this.acInfo);
            Signature sig = Signature.getInstance(this.signatureAlgorithm.getObjectId().getId());
            sig.initVerify(key);
            sig.update(b.toByteArray());
            return sig.verify(this.signatureValue.getBytes());
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Error verifying signature of AC issued by " + this.getIssuer().getName() + " : " + e.getMessage()));
            }
            return false;
        }
    }

    public DERObject getDERObject() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((DEREncodable)this.acInfo);
        v.add((DEREncodable)this.signatureAlgorithm);
        v.add((DEREncodable)this.signatureValue);
        return new DERSequence((DEREncodableVector)v);
    }
}

